/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.ProgressBean;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressDetails;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;

public class ProgressActionHandler
implements TaskActionListener,
TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMPAHT";
    private static final String TRACE_MASKF = "XFRMPAHF";
    private static final String TRACE_MASKD = "XFRMPAHD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "ProgActHdlr");

    public void actionPerformed(TaskActionEvent evt) {
        String command = evt.getActionCommand();
        UserTaskManager utm = (UserTaskManager)evt.getSource();
        if (command.equals("CancelTaskButton")) {
            Trace.trace(TRACE_MASKT, "-> ProgressActionHandler for CancelTaskButton");
            if (utm != null) {
                ProgressBean bean = (ProgressBean)utm.getDataObjects()[0];
                ProgressStartEvent start = bean.getStartEvent();
                ProgressCancelListener callback = start.getProgressCancelListener();
                if (callback != null) {
                    CancelThread tid = new CancelThread(callback, null, start.getId());
                    tid.start();
                } else {
                    Trace.trace(TRACE_MASKF, "Cancel callback is null, so ignoring action");
                }
                utm.setEnabled("CancelTaskButton", false);
                bean.setCanceled(true);
            } else {
                Trace.trace(TRACE_MASKF, "null UserTaskManager");
            }
            Trace.trace(TRACE_MASKT, "<- ProgressActionHandler for CancelTaskButton");
        } else if (command.equals("OKButton")) {
            Trace.trace(TRACE_MASKT, "-> ProgressActionHandler for OKButton");
            if (utm != null) {
                ProgressBean bean = (ProgressBean)utm.getDataObjects()[0];
                ProgressStartEvent start = bean.getStartEvent();
                ProgressEndedListener callback = start.getProgressEndedListener();
                if (callback != null) {
                    CancelThread tid = new CancelThread(null, callback, start.getId());
                    tid.start();
                } else {
                    Trace.trace(TRACE_MASKF, "progressEnded callback is null, so no one is being notified");
                }
                utm.dispose();
            } else {
                Trace.trace(TRACE_MASKF, "null UserTaskManager");
            }
            Trace.trace(TRACE_MASKT, "<- ProgressActionHandler for OKButton");
        } else if (command.equals("DetailsButton")) {
            block48: {
                Trace.trace(TRACE_MASKT, "-> ProgressActionHandler for DetailsButton");
                if (utm != null) {
                    ProgressBean bean = (ProgressBean)utm.getDataObjects()[0];
                    if (bean != null) {
                        ProgressStartEvent start = bean.getStartEvent();
                        ProgressData[] startData = start.getProgressData();
                        int[] selRows = null;
                        if (startData != null) {
                            selRows = startData.length == 1 && startData[0].getObjectId() == null ? new int[]{0} : utm.getSelectedRows("TargetProgressTable");
                        }
                        if (selRows != null && selRows.length > 0) {
                            ProgressData[] data = start.getProgressData();
                            if (data != null && selRows[0] < data.length && selRows[0] >= 0) {
                                Object details = data[selRows[0]].getDetails();
                                if (details != null) {
                                    if (details instanceof ProgressDetails) {
                                        ((ProgressDetails)details).displayDetails();
                                    } else {
                                        MsgType type;
                                        LocalizableText title;
                                        Object[] subst;
                                        if (data[selRows[0]].getObjectId() == null) {
                                            subst = new String[]{start.getTaskName().toString().replace('\n', ' ')};
                                            title = new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.details_title_notarget", subst);
                                        } else {
                                            subst = new String[]{start.getTaskName().toString().replace('\n', ' '), data[selRows[0]].getName().toString().replace('\n', ':')};
                                            title = new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.details_title", subst);
                                        }
                                        switch (data[selRows[0]].getCompletionStatus()) {
                                            case 2: {
                                                type = MsgType.WARNING_MESSAGE;
                                                break;
                                            }
                                            case 3: {
                                                type = MsgType.ERROR_MESSAGE;
                                                break;
                                            }
                                            default: {
                                                type = MsgType.INFORMATION_MESSAGE;
                                            }
                                        }
                                        LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                                        String fakeId = "          ";
                                        try {
                                            MessageText[] msg2;
                                            if (details instanceof MessageText[]) {
                                                MessageText[] msg2 = (MessageText[])details;
                                                CommonMsgApp.showMessageBox(utm, title, msg2, fakeId, type, options);
                                                break block48;
                                            }
                                            if (details instanceof MessageText) {
                                                MessageText[] msg2 = new MessageText[]{(MessageText)details};
                                                CommonMsgApp.showMessageBox(utm, title, msg2[0]);
                                                break block48;
                                            }
                                            if (details instanceof LocalizableText[]) {
                                                LocalizableText[] txt = (LocalizableText[])details;
                                                msg2 = new MessageText[txt.length];
                                                int j = 0;
                                                while (j < txt.length) {
                                                    msg2[j] = new MessageText(null, fakeId + txt[j].toString());
                                                    ++j;
                                                }
                                            } else {
                                                msg2 = new MessageText[]{new MessageText(null, fakeId + details.toString())};
                                            }
                                            CommonMsgApp.showMessageBox(utm, title, msg2, fakeId, type, options);
                                        }
                                        catch (HException ex) {
                                            new FrameworkLog(classLogInfo, 53, ex).log();
                                        }
                                    }
                                } else {
                                    try {
                                        LocalizableText title;
                                        if (data[selRows[0]].getObjectId() == null) {
                                            Object[] subst = new String[]{start.getTaskName().toString().replace('\n', ' ')};
                                            title = new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.details_title_notarget", subst);
                                        } else {
                                            Object[] subst = new String[]{start.getTaskName().toString().replace('\n', ' '), data[selRows[0]].getName().toString().replace('\n', ':')};
                                            title = new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.details_title", subst);
                                        }
                                        CommonMsgApp.showMessageBox(utm, title, new BaseMessageText("TSK0012"));
                                    }
                                    catch (Exception e) {
                                        Trace.trace(TRACE_MASKF, e);
                                    }
                                }
                            }
                        } else {
                            try {
                                Object[] subst = new String[]{start.getTaskName().toString().replace('\n', ' ')};
                                LocalizableText title = new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.details_title_notarget", subst);
                                CommonMsgApp.showMessageBox(utm, title, new BaseMessageText("TSK0011"));
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, e);
                            }
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "null UserTaskManager");
                    }
                }
            }
            Trace.trace(TRACE_MASKT, "<- ProgressActionHandler for DetailsButton");
        } else if (command.equals("CANCEL")) {
            if (utm == null || !utm.isEnabled("OKButton")) {
                throw new IllegalUserDataException();
            }
            ProgressBean bean = (ProgressBean)utm.getDataObjects()[0];
            ProgressStartEvent start = bean.getStartEvent();
            ProgressEndedListener callback = start.getProgressEndedListener();
            if (callback != null) {
                CancelThread tid = new CancelThread(null, callback, start.getId());
                tid.start();
            } else {
                Trace.trace(TRACE_MASKF, "progressEnded callback is null, so no one is being notified");
            }
            utm.dispose();
        }
    }

    static void callListener(ProgressCancelListener cancel, ProgressEndedListener ended, String id) {
        CancelThread tid = new CancelThread(cancel, ended, id);
        tid.start();
    }

    private static class CancelThread
    extends Thread {
        private ProgressCancelListener cancelCallback;
        private ProgressEndedListener endedCallback;
        private String id;

        private CancelThread(ProgressCancelListener cancel, ProgressEndedListener ended, String id) {
            this.cancelCallback = cancel;
            this.endedCallback = ended;
            this.id = id;
        }

        public void run() {
            try {
                if (this.cancelCallback != null) {
                    this.cancelCallback.progressCanceled(this.id);
                } else if (this.endedCallback != null) {
                    this.endedCallback.progressEnded(this.id);
                }
            }
            catch (Exception ex) {
                Trace.trace(ProgressActionHandler.TRACE_MASKF, "Exception occurred calling Cancel/Ended callback: " + ex);
            }
        }
    }
}

